// priority: 27

NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.living.LivingEntityUseItemEvent$Finish"), e => {
    let 实体 = e.getEntity();
    if (!实体 || !(实体 instanceof $玩家) || 实体.level.isClientSide()) {
        return;
    }

    let 玩家 = 实体;
    let 物品堆栈 = e.getItem();
    let 效果列表 = 食物效果定义[物品堆栈.id];
    
    if (效果列表 && Array.isArray(效果列表)) {
        
        效果列表.forEach(效果定义 => {
            
            if (效果定义.类型 === "属性") {
                let 属性信息 = 食物效果属性表[效果定义.属性];
                if (!属性信息) return;

                let 操作 = 操作映射[效果定义.操作];
                if (!操作) return;

                let 属性ID = 属性信息.id;
                let 属性UUID = $唯一标识符.fromString(属性信息.uuid);
                let 属性对象 = $注册中心.ATTRIBUTES.getValue(new $资源位置(属性ID));
                if (!属性对象) return;

                let 玩家属性实例 = 玩家.getAttribute(属性对象);
                if (!玩家属性实例) return;
                
                let 修饰符名称 = `食物效果: ${效果定义.属性}`;
                let 新修饰符 = new $属性修改器(属性UUID, 修饰符名称, 效果定义.数值, 操作);
                
                玩家属性实例.addPermanentModifier(新修饰符);
                玩家.tell(Component.translate("kubejs.message.food_effect.attribute_added", Text.of(效果定义.属性).green()));
            }
            
            else if (效果定义.类型 === "移除属性") {
                let 属性信息 = 食物效果属性表[效果定义.属性];
                if (!属性信息) return;

                let 属性ID = 属性信息.id;
                let 属性UUID = $唯一标识符.fromString(属性信息.uuid);
                let 属性对象 = $注册中心.ATTRIBUTES.getValue(new $资源位置(属性ID));
                if (!属性对象) return;

                let 玩家属性实例 = 玩家.getAttribute(属性对象);
                if (玩家属性实例 && 玩家属性实例.getModifier(属性UUID) != null) {
                    玩家属性实例.removeModifier(属性UUID);
                    玩家.tell(Component.translate("kubejs.message.food_effect.attribute_removed", Text.of(效果定义.属性).yellow()));
                }
            }

            else if (效果定义.类型 === "药水") {
                let 药水效果ID = 效果定义.药水ID;
                let 效果类型 = $注册中心.MOB_EFFECTS.getValue(new $资源位置(药水效果ID));
                if (!效果类型) return;
                
                let 等级 = 效果定义.等级 || 0;
                let 是永久效果 = (效果定义.时长 === -1);
                
                if (是永久效果) {
                    let 永久时长 = 2147483647;
                    let 新药水效果 = new $药水效果实例(效果类型, 永久时长, 等级, false, false, false);
                    玩家.addEffect(新药水效果);
                    玩家.tell(Component.translate("kubejs.message.food_effect.potion_permanent", Text.of(效果类型.displayName.string).yellow()));
                } else {
                    let 持续刻数 = (效果定义.时长 || 0) * 20;
                    if (持续刻数 > 0) {
                        let 新药水效果 = new $药水效果实例(效果类型, 持续刻数, 等级, false, true, true);
                        玩家.addEffect(新药水效果);
                        玩家.tell(Component.translate("kubejs.message.food_effect.potion_temporary", Text.of(效果类型.displayName.string).yellow()));
                    }
                }
            }
        });
    }
});